#[tokio::main]
async fn iroh_test(cmd: IrohCommands) -> Result<()> {
    let trusted_nodes = [
        NodeId::from_str("e218fe657a62e2049f66252e85e665480fa9ecae1a93bb523138580f49e71877")?, // receive
        NodeId::from_str("1f5b63485335333cd011e23960e7d0859490ad24fefb8ee625e231d312844034")?, // send
    ];

    let endpoint = iroh::Endpoint::builder()
        // .secret_key(get_or_create_secret()?)
        .secret_key(match cmd {
            IrohCommands::Send { .. } => iroh::SecretKey::from_str(
                "b1749135e836aec4fb63edbd0f09dabcd95cdde5231b8207508b91f10fe47f06",
            )?,
            IrohCommands::Receive { .. } => iroh::SecretKey::from_str(
                "b1749135e836aec4fb63edbd0f09dabcd95cdde5231b8207508b91f10fe47f07",
            )?,
        })
        .discovery_local_network()
        .relay_mode(iroh::RelayMode::Disabled)
        .bind()
        .await?;
    let node_id = endpoint.node_id();
    println!("> our node id: {node_id:?}"); // TODO remove this is secret info
    for local_endpoint in endpoint.direct_addresses().initialized().await? {
        println!("\t{}", local_endpoint.addr)
    }

    // let access_limiter = iroh::protocol::AccessLimit::new(Echo, move |node_id: NodeId| {
    //     trusted_nodes.contains(&node_id)
    // });

    let router = iroh::protocol::Router::builder(endpoint)
        .accept(ALPN, Echo)
        .spawn();

    match cmd {
        IrohCommands::Send { addr, msg } => {
            println!("Sending message:{msg}");
            let conn = router
                .endpoint()
                .connect(NodeId::from_str(&addr)?, ALPN)
                .await?;
            let (mut send, mut recv) = conn.open_bi().await?;

            send.write_all(msg.as_bytes()).await?;

            send.finish()?;
            send.stopped().await?;

            let response = recv.read_to_end(1000).await?;
            println!("Received response: {}", String::from_utf8_lossy(&response));

            conn.close(0u32.into(), b"done");
        }
        IrohCommands::Receive {} => {
            println!("Waiting for incoming messages...");
            tokio::signal::ctrl_c().await?;
        }
    };

    router.shutdown().await?;
    Ok(())
}